@extends('layouts.master_panel')

@section('title') Travaux à faire (devoirs) @stop

@section('CSS') 


<link rel="stylesheet" href="{{url('/')}}/assets/vendor/datepicker/tempusdominus-bootstrap-4.css" />

<style type="text/css">
  @media screen and (max-width:1000px) {
    .infoTable { display: block !important; }
  }
</style>

@stop

@section('JS') 




<script src="{{url('/')}}/assets/vendor/datepicker/moment.js"></script>
<script src="{{url('/')}}/assets/vendor/datepicker/tempusdominus-bootstrap-4.js"></script>
<script src="{{url('/')}}/assets/vendor/datepicker/datepicker.js"></script>

<script src="{{url('/')}}/assets/vendor/datepicker/fr.js"></script>

<script type="text/javascript">
     $(function () {
        $('#datetimepickerdateHon').datetimepicker({
          format: 'DD/MM/YYYY',
          locale: 'fr'
      });
    });

    $(function () {
        $('#datetimepickerdateHon2').datetimepicker({
          format: 'DD/MM/YYYY',
          locale: 'fr'
      });
    });

</script>




@stop


@section('content')


                  <!-- ============================================================== -->
                  <!-- pageheader  -->
                  <!-- ============================================================== -->
                  <div class="row">
                      <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                          <div class="page-header">
                              <h3 class="mb-2">Travaux à faire (devoirs)</h3>
                           
                              <div class="page-breadcrumb">
                                  <nav aria-label="breadcrumb">
                                      <ol class="breadcrumb">
                                          <li class="breadcrumb-item active" aria-current="page">Travaux à faire (devoirs)</li>
                                      </ol>
                                  </nav>
                              </div>
                          </div>
                      </div>
                  </div>
                  <!-- ============================================================== -->
                  <!-- end pageheader  -->
                  <!-- ============================================================== -->


<div class="row">


<div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
  <div class="card">
  <h5 class="card-header">
      <a href="#" class="btn btn-primary mb-1" data-toggle="modal" data-target="#exampleModal"><i class="fa fa-clock"></i>  Consultez les anciens devoirs </a>
  </h5>
  <div class="card-body">




<?php 
$days_en = ['Monday','Tuesday','Wednesday','Thursday','Friday','Saturday'];
$days_fr = ['Lundi','Mardi','Mercredi','Jeudi','Vendredi','Samedi'];


//$friday = strtotime('last friday', strtotime(date('2021-04-09')));
$friday = strtotime('last friday', strtotime('tomorrow'));
$sunday = strtotime('+7 days', $friday);
//echo "<P>". date('Y-m-d', $friday) . " to " . date('Y-m-d', $sunday) . "</P>";


$from = date('Y-m-d', $friday);
$to = date('Y-m-d', $sunday);

$devoirs = \App\Devoirs::where('preparation_exam', null)->where('class_id', auth()->user()->class_id)->whereBetween('date_en', [$from, $to])->orderBy('date_en', 'asc')->get();


$fromFR = \DateTime::createFromFormat('Y-m-d', $from); 
$toFR = \DateTime::createFromFormat('Y-m-d', $to); 

                    
 ?>




<!-- Modal -->
<div class="modal fade" id="exampleModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
<div class="modal-dialog" role="document">
  <div class="modal-content">
    <div class="modal-header">
      <h5 class="modal-title" id="exampleModalLabel">Consultez les anciens devoirs</h5>
      <a href="#" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></a>
    </div>
    <div class="modal-body">

<form method="GET" action="{{ URL::route('students_devoirs') }}">

<div class="row">

<div class="col-md-12 mb-3">
    <label>Période du:</label>
    <div class="form-group">
    <div class="input-group date" id="datetimepickerdateHon" data-target-input="nearest">

    <input name="from" type="text" class="form-control datetimepicker-input" data-target="#datetimepickerdateHon" value="{{ $fromFR->format('d/m/Y') }}" />
    
      <div class="input-group-append" data-target="#datetimepickerdateHon" data-toggle="datetimepicker">
      <div class="input-group-text"><i class="far fa-calendar-alt"></i></div>
      </div>
    </div>
  </div>
</div>

<div class="col-md-12 mb-3">
    <label>Période au:</label>
    <div class="form-group">
    <div class="input-group date" id="datetimepickerdateHon2" data-target-input="nearest">

    <input name="to" type="text" class="form-control datetimepicker-input" data-target="#datetimepickerdateHon2" readonly="readonly" value="{{ $toFR->format('d/m/Y') }}" />
    
      <div class="input-group-append" data-target="#datetimepickerdateHon2" data-toggle="datetimepicker">
      <div class="input-group-text"><i class="far fa-calendar-alt"></i></div>
      </div>
    </div>
  </div>
</div>


</div>

<div class="row mt-1">
<div class="col-md-12">
    <button class="btn btn-success btn-block" type="submit">Consultez les anciens devoirs</button>
</div>
</div>

</form>

    </div>
    <div class="modal-footer">
      <a href="#" class="btn btn-dark" data-dismiss="modal">Fermer</a>
    </div>
  </div>
</div>
</div>
<!-- End Modal -->




<h3 class="text-center">Travaux à faire pour semaine du {{ $fromFR->format('d/m/Y') }} au {{ $toFR->format('d/m/Y') }}</h3>

<div style="text-align: center; margin: auto; display: none;" class="infoTable mb-2">
<img src="{{ url('/') }}/assets/images/move.png" width="50px"></div>

<div class="table-responsive">
  <table class="table table-bordered">
    <thead>
      <tr class="text-uppercase">
        @foreach($days_fr as $day_fr)
        <th style="width: 16.66%;">{{ $day_fr }}</th>
        @endforeach
      </tr>
    </thead>
    <tbody>

<tr>
      @foreach($days_fr as $day_fr)
        <td>
<?php 

$key = array_search($day_fr, $days_fr); 
//echo $days_en[$key] . '<br>';

foreach ($devoirs as $devoir) {

  $dayName = date('l', strtotime($devoir->date_en));
  if ($dayName == $days_en[$key]) {
    
    //echo $devoir->date_en . ' - ' . $devoir->title . '<br>';

    echo '<span class="badge badge-primary mr-2 mb-1"> <i class="fas fa-book"></i> ' . $devoir->subject->name . ' - ' . $devoir->date. ' </span>';


    echo '<p class="bg-primary p-2"> ' . $devoir->title . '
      <br>
      <a href="'. URL::route("devoir_details", $devoir->id) .'" class="btn btn-warning btn-xs">Voir le Travail</a></p>';

  }

}

 ?>


        </td>
      @endforeach    
</tr>



    </tbody>
  </table><!-- .table -->
</div>




</div>
</div>
</div>



</div><!-- END row -->
                
               

@stop