<?php

use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
*/

//*----- ARICHIVE YEAR -----*//
/*
Route::get('/archive_THIS_year', function() {

    $new_year =	\App\AcademicYear::create([
    	'name' => '2021/2022',
    ]);
   	$new_year->save();

   	\DB::table('settings')->update(['default_year'=>$new_year->id]);
   	\DB::table('subjects')->update(['year_id'=>$new_year->id]);
   	\DB::table('subject_names')->update(['year_id'=>$new_year->id]);
   	\DB::table('classes')->update(['year_id'=>$new_year->id]);

   	echo 'Done: ' . $new_year->name;
});
*/


Route::get('/fixing_passwords', function() {

   	$students = \App\User::where('is_student', 1)->get();
   	foreach ($students as $student) {
   		
   		$student->password = Hash::make('@123456789');
   		$student->mptxt = '@123456789';
   		$student->save();
   	}


   	$teachers = \App\User::where('is_teacher', 1)->Orwhere('is_oldteacher', 1)->get();
   	foreach ($teachers as $teacher) {
   		
   		$teacher->password = Hash::make('@123456789');
   		$teacher->mptxt = '@123456789';
   		$teacher->save();
   	}


   	echo 'fixed!';


});


Route::get('/fixing_email', function() {

   	$students = \App\User::where('is_student', 1)->get();
   	foreach ($students as $student) {
   		$createEmail = str_replace(" ", "", $student->username);
   		$student->username = $createEmail;
   		$student->save();
   	}


   	echo 'fixed!';


});


//*----- END ARICHIVE YEAR -----*//


Route::get('/', ['as'=>'login', 'uses'=>'AdminController@login']);

Route::post('/login/check', ['as'=>'login_check', 'uses'=>'AdminController@login_check']);

Route::get('/logout', ['as'=>'logout', 'uses'=>'AdminController@logout']);




Route::get('/pointage', ['as'=>'pointage', 'uses'=>'AdminController@pointage']);
Route::post('/pointage/scan', ['as'=>'pointage_scan', 'uses'=>'AdminController@pointage_scan']);

Route::get('/pointage/pointagelogin', ['as'=>'pointagelogin', 'uses'=>'AdminController@pointagelogin']);

Route::post('/pointage/checkpassword', ['as'=>'pointage_checkpassword', 'uses'=>'SettingsController@pointage_checkpassword']);



Route::group(['middleware' => 'auth'], function () {

	// Devoirs
	Route::get('/devoirs', ['as'=>'public_devoirs', 'uses'=>'AdminController@public_devoirs']);


	Route::get('/ajax_teacher_classes_subjects', ['as'=>'ajax_enseignant_classes_subjects', 'uses'=>'EnseignantsController@ajax_enseignant_classes_subjects']);



	// update password
	Route::get('/update_password', ['as'=>'update_password', 'uses'=>'AdminController@update_password']);
	Route::post('/update_password/store', ['as'=>'update_password_store', 'uses'=>'AdminController@update_password_store']);


});




Route::group(['middleware' => 'is_admin'], function () {


	// agents role
	Route::get('/admin/agents', ['as'=>'agents_role', 'uses'=>'PersonnelController@agents_role']);

	Route::post('/admin/agents/store', ['as'=>'store_agents_role', 'uses'=>'PersonnelController@store_agents_role']);

	Route::post('/admin/agents/{id}/update', ['as'=>'update_agents_role', 'uses'=>'PersonnelController@update_agents_role']);



	Route::get('/admin', ['as'=>'admin_index', 'uses'=>'AdminController@admin_index']);


	// settings
	Route::get('/admin/settings', ['as'=>'settings', 'uses'=>'SettingsController@settings']);
	Route::post('/admin/settings/administrateur/update', ['as'=>'administrateur_update', 'uses'=>'SettingsController@administrateur_update']);

	Route::post('/admin/settings/academic_year', ['as'=>'academic_year', 'uses'=>'SettingsController@academic_year']);

	Route::post('/admin/settings/pointage_password', ['as'=>'pointage_password', 'uses'=>'SettingsController@pointage_password']);

	// Horaires
	Route::post('/admin/settings/horaires/store', ['as'=>'horaires_store', 'uses'=>'SettingsController@horaires_store']);

	Route::get('/admin/settings/horaires/{id}/delete', ['as'=>'horaire_delete', 'uses'=>'SettingsController@horaire_delete']);

	Route::post('/admin/settings/horaires/{id}/update', ['as'=>'horaire_update', 'uses'=>'SettingsController@horaire_update']);



	// Enseignants
	Route::get('/admin/enseignants', ['as'=>'enseignants', 'uses'=>'EnseignantsController@enseignants']);
	Route::post('/admin/enseignants/store', ['as'=>'enseignants_store', 'uses'=>'EnseignantsController@enseignants_store']);
	Route::get('/admin/enseignants/{id}/edit', ['as'=>'enseignant_edit', 'uses'=>'EnseignantsController@enseignant_edit']);
	Route::post('/admin/enseignants/{id}/update', ['as'=>'enseignant_update', 'uses'=>'EnseignantsController@enseignant_update']);
	Route::post('/admin/enseignants/{id}/enseignant_password_update', ['as'=>'enseignant_password_update', 'uses'=>'EnseignantsController@enseignant_password_update']);
	Route::get('/admin/enseignants/{id}/delete', ['as'=>'enseignant_destroy', 'uses'=>'EnseignantsController@enseignant_destroy']);
	Route::post('/admin/enseignants/importer', ['as'=>'enseignants_importer', 'uses'=>'EnseignantsController@enseignants_importer']);


	Route::get('/admin/enseignants/export', ['as'=>'enseignants_export', 'uses'=>'EnseignantsController@enseignants_export']);

	// enseignants suspendus
	Route::get('/admin/enseignants_suspendus', ['as'=>'enseignants_suspendus', 'uses'=>'EnseignantsController@enseignants_suspendus']);


	//--> disable or active teacher
	Route::get('/admin/enseignants/{id}/disable_teacher', ['as'=>'disable_teacher', 'uses'=>'EnseignantsController@disable_teacher']);
	Route::get('/admin/enseignants/{id}/active_teacher', ['as'=>'active_teacher', 'uses'=>'EnseignantsController@active_teacher']);


	// Enseignants horaires travail
	Route::post('/admin/enseignants/horaires', ['as'=>'enseignant_horaires', 'uses'=>'EnseignantsController@enseignant_horaires']);

	Route::get('/admin/enseignants/horaires/{id}/delete', ['as'=>'horaires_destroy', 'uses'=>'EnseignantsController@horaires_destroy']);


	Route::get('/admin/ajax_teacher_classes', ['as'=>'ajax_enseignant_classes', 'uses'=>'EnseignantsController@ajax_enseignant_classes']);


	// Importer horaires
	Route::post('/admin/enseignants/horaires_importer', ['as'=>'horaires_importer', 'uses'=>'EnseignantsController@horaires_importer']);




	// les élèves
	Route::get('/admin/students', ['as'=>'students', 'uses'=>'StudentsController@students']);

	Route::post('/admin/students/importer', ['as'=>'students_importer', 'uses'=>'StudentsController@students_importer']);

	Route::post('/admin/students/store', ['as'=>'students_store', 'uses'=>'StudentsController@students_store']);

	Route::get('/admin/students/{id}/edit', ['as'=>'student_edit', 'uses'=>'StudentsController@student_edit']);

	Route::post('/admin/students/{id}/update', ['as'=>'student_update', 'uses'=>'StudentsController@student_update']);

	Route::post('/admin/students/{id}/student_password_update', ['as'=>'student_password_update', 'uses'=>'StudentsController@student_password_update']);

	Route::get('/admin/students/{id}/delete', ['as'=>'student_destroy', 'uses'=>'StudentsController@student_destroy']);

	
	Route::get('/admin/students/export', ['as'=>'students_export', 'uses'=>'StudentsController@students_export']);


	// classes et matières
	Route::get('/admin/classes_subjects', ['as'=>'classes_subjects', 'uses'=>'EnseignantsController@classes_subjects']);

	//--> classes
	Route::post('/admin/classes_subjects/classe/store', ['as'=>'classes_store', 'uses'=>'EnseignantsController@classes_store']);
	Route::post('/admin/classes_subjects/classe/{id}/update', ['as'=>'classe_update', 'uses'=>'EnseignantsController@classe_update']);
	Route::get('/admin/classes_subjects/classe/{id}/delete', ['as'=>'classe_destroy', 'uses'=>'EnseignantsController@classe_destroy']);

	//--> subject
	Route::post('/admin/classes_subjects/subject/store', ['as'=>'subject_store', 'uses'=>'EnseignantsController@subject_store']);
	Route::post('/admin/classes_subjects/subject/{id}/update', ['as'=>'subject_update', 'uses'=>'EnseignantsController@subject_update']);
	Route::get('/admin/classes_subjects/subject/{id}/delete', ['as'=>'subject_destroy', 'uses'=>'EnseignantsController@subject_destroy']);

	//--> subject names
	Route::post('/admin/classes_subjects/subject_names/store', ['as'=>'subject_names_store', 'uses'=>'EnseignantsController@subject_names']);

	Route::post('/admin/classes_subjects/subject_names/{id}/update', ['as'=>'subject_names_update', 'uses'=>'EnseignantsController@subject_names_update']);

	Route::get('/admin/classes_subjects/subject_names/{id}/delete', ['as'=>'subject_names_destroy', 'uses'=>'EnseignantsController@subject_names_destroy']);



	// dossiers
	Route::get('/admin/dossiers', ['as'=>'enseignant_dossiers', 'uses'=>'AdminController@enseignant_dossiers']);

	Route::get('/admin/old_dossiers/{id}', ['as'=>'admin_old_dossiers', 'uses'=>'AdminController@enseignant_old_dossiers']);


	Route::get('/admin/dossiers/{id}/delete', ['as'=>'folder_delete', 'uses'=>'AdminController@folder_delete']);
	Route::get('/admin/dossiers/{id}/files', ['as'=>'enseignant_dossiers_files', 'uses'=>'AdminController@enseignant_dossiers_files']);
	Route::get('/admin/dossiers/files/{id}/delete', ['as'=>'file_delete', 'uses'=>'AdminController@file_delete']);

	Route::get('/admin/dossiers/non-depose', ['as'=>'enseignants_nondepose', 'uses'=>'AdminController@enseignants_nondepose']);



	// historique
	Route::get('/admin/historique', ['as'=>'historique', 'uses'=>'AdminController@historique']);
	Route::get('/admin/historique/{id}/delete', ['as'=>'historique_delete', 'uses'=>'AdminController@historique_delete']);

	Route::get('/admin/historique/delete_all', ['as'=>'historique_delete_all', 'uses'=>'AdminController@historique_delete_all']);

	Route::get('/admin/ressources_historique', ['as'=>'ressources_historique', 'uses'=>'AdminController@ressources_historique']);


	// Répartition 
	Route::get('/admin/repartition', ['as'=>'admin_repartition', 'uses'=>'AdminController@repartition']);


	// cahier journal 
	Route::get('/admin/cahier_journal', ['as'=>'admin_cahier_journal', 'uses'=>'AdminController@cahier_journal']);

	Route::get('/admin/cahier_journal/{id}/delete', ['as'=>'admin_journal_delete', 'uses'=>'EnseignantsController@cahier_journal_delete']);

	Route::get('/admin/cahier_journal/{id}/print', ['as'=>'admin_journal_print', 'uses'=>'AdminController@cahier_journal_print']);

	Route::get('/admin/cahier_journal/historique', ['as'=>'journal_historique', 'uses'=>'AdminController@journal_historique']);

	Route::get('/admin/cahier_journal/print-all', ['as'=>'cahier_journal_print_all', 'uses'=>'AdminController@cahier_journal_print_all']);

	Route::get('/admin/cahier_journal/honoraire', ['as'=>'cahier_journal_honoraire', 'uses'=>'AdminController@cahier_journal_honoraire']);


	Route::get('/admin/cahier_journal/{id}/edit', ['as'=>'admin_journal_edit', 'uses'=>'AdminController@cahier_journal_edit']);
	Route::post('/admin/cahier_journal/{id}/update', ['as'=>'admin_journal_update', 'uses'=>'AdminController@cahier_journal_update']);



	// Devoirs
	Route::get('/admin/devoirs', ['as'=>'admin_devoirs', 'uses'=>'AdminController@devoirs']);

	Route::get('/admin/devoirs/{id}/delete', ['as'=>'admin_devoir_delete', 'uses'=>'EnseignantsController@devoirs_delete']);


	// devoirs alerts
	Route::get('/admin/devoirs/alerts', ['as'=>'admin_devoirs_alerts', 'uses'=>'AdminController@devoirs_alerts']);



	// pointage historique 
	Route::get('/admin/pointage_historique', ['as'=>'pointage_historique', 'uses'=>'AdminController@pointage_historique']);

	Route::get('/admin/pointage_historique/print', ['as'=>'pointage_historique_print', 'uses'=>'AdminController@pointage_historique_print']);

	Route::get('/admin/pointage_historique/{id}/delete', ['as'=>'pointage_delete', 'uses'=>'AdminController@pointage_delete']);

	Route::get('/admin/pointage_historique/delete_all', ['as'=>'pointage_delete_delete_all', 'uses'=>'AdminController@pointage_delete_delete_all']);


	// badges
	Route::get('/admin/pointage_historique/badges/enseignants', ['as'=>'badges', 'uses'=>'AdminController@enseignants_badges']);

	Route::get('/admin/pointage_historique/badges/students', ['as'=>'students_badges', 'uses'=>'AdminController@students_badges']);

	Route::get('/admin/pointage_historique/badges/personnel', ['as'=>'personnel_badges', 'uses'=>'AdminController@personnel_badges']);


	// Assiduité  
	Route::get('/admin/assiduite', ['as'=>'admin_assiduite', 'uses'=>'AdminController@admin_assiduite']);

	Route::get('/admin/assiduite/historique', ['as'=>'assiduite_historique', 'uses'=>'AdminController@assiduite_historique']);


	// Assiduité motifs
	Route::post('/admin/settings/assiduite/store', ['as'=>'assiduite_motifs_store', 'uses'=>'SettingsController@assiduite_motifs_store']);

	Route::get('/admin/settings/assiduite/{id}/delete', ['as'=>'assiduite_motifs_delete', 'uses'=>'SettingsController@assiduite_motifs_delete']);

	Route::post('/admin/settings/assiduite/{id}/update', ['as'=>'assiduite_motifs_update', 'uses'=>'SettingsController@assiduite_motifs_update']);


	// Contrôle continu  
	Route::get('/admin/evaluations/controle-continu', ['as'=>'admin_evaluations_controle', 'uses'=>'AdminController@evaluations_controle']);


	// Simili  
	Route::get('/admin/evaluations/simili', ['as'=>'admin_evaluations_simili', 'uses'=>'AdminController@admin_evaluations_simili']);

	

	// personnel
	Route::get('/admin/personnel', ['as'=>'personnel', 'uses'=>'PersonnelController@personnel']);

	Route::post('/admin/personnel/store', ['as'=>'personnel_store', 'uses'=>'PersonnelController@personnel_store']);

	Route::get('/admin/personnel/{id}/edit', ['as'=>'personnel_edit', 'uses'=>'PersonnelController@personnel_edit']);

	Route::post('/admin/personnel/{id}/update', ['as'=>'personnel_update', 'uses'=>'PersonnelController@personnel_update']);

	Route::post('/admin/personnel/{id}/personnel_password_update', ['as'=>'personnel_password_update', 'uses'=>'PersonnelController@personnel_password_update']);

	Route::get('/admin/personnel/{id}/delete', ['as'=>'personnel_destroy', 'uses'=>'PersonnelController@personnel_destroy']);


	// personnel types
	Route::post('/admin/settings/personnel_type/store', ['as'=>'personnel_type_store', 'uses'=>'SettingsController@personnel_type_store']);

	Route::post('/admin/settings/personnel_type/{id}/update', ['as'=>'personnel_type_update', 'uses'=>'SettingsController@personnel_type_update']);

	Route::get('/admin/settings/personnel_type/{id}/delete', ['as'=>'personnel_type_delete', 'uses'=>'SettingsController@personnel_type_delete']);

	
	// compte rendu  
	Route::get('/admin/compte_rendu', ['as'=>'admin_compte_rendu', 'uses'=>'AdminController@admin_compte_rendu']);


	// Préparation à l'exam 
	Route::get('/admin/preparation', ['as'=>'admin_preparation_exam', 'uses'=>'AdminController@preparation_exam']);


	// absence request
	Route::get('/admin/absence_request', ['as'=>'admin_absence_request', 'uses'=>'EnseignantsController@enseignant_absence_request']);

	Route::post('/admin/absence_request/{id}/decision', ['as'=>'absence_request_decision', 'uses'=>'EnseignantsController@absence_request_decision']);


	// non déposé
	Route::get('/admin/devoirs/non-depose', ['as'=>'devoirs_non_depose', 'uses'=>'AdminController@devoirs_non_depose']);


	// Emploi du temps & dépôt des documents 
	Route::get('/admin/emploi-depot_document', ['as'=>'admin_emploi', 'uses'=>'AdminController@emploi']);

	Route::post('/admin/emploi-depot_document/store', ['as'=>'admin_emploi_store', 'uses'=>'AdminController@emploi_store']);

	Route::get('/admin/emploi/{id}/delete', ['as'=>'admin_emploi_delete', 'uses'=>'AdminController@emploi_delete']);

	Route::get('/admin/depot_document/{id}/delete', ['as'=>'admin_depot_document_delete', 'uses'=>'AdminController@depot_document_delete']);


	// documents names
	Route::post('/admin/settings/documents_request/store', ['as'=>'documents_request_store', 'uses'=>'SettingsController@documents_request_store']);

	Route::post('/admin/settings/documents_request/{id}/update', ['as'=>'documents_request_update', 'uses'=>'SettingsController@documents_request_update']);

	Route::get('/admin/settings/documents_request/{id}/delete', ['as'=>'documents_request_delete', 'uses'=>'SettingsController@documents_request_delete']);

	// docs request
	Route::get('/admin/demandes_documents', ['as'=>'admin_demandes_documents', 'uses'=>'EnseignantsController@demandes_documents']);

	Route::get('/admin/demandes_documents/{id}/delete', ['as'=>'admin_documents_delete', 'uses'=>'EnseignantsController@demandes_documents_delete']);

	Route::get('/admin/demandes_documents/{id}/traitee', ['as'=>'admin_documents_traitee', 'uses'=>'EnseignantsController@demandes_documents_traitee']);


	// update users mass
	Route::post('/admin/settings/users_mass_update', ['as'=>'users_mass_update', 'uses'=>'SettingsController@users_mass_update']);



	// planning des devoirs
	Route::get('/admin/planning_devoirs', ['as'=>'admin_planning_devoirs', 'uses'=>'AdminController@planning_devoirs']);

	Route::post('/admin/planning_devoirs/store', ['as'=>'planning_devoirs_store', 'uses'=>'AdminController@planning_devoirs_store']);

	Route::get('/admin/planning_devoirs/{id}/delete', ['as'=>'planning_devoirs_delete', 'uses'=>'AdminController@planning_devoirs_delete']);


	// orientation

	Route::get('/admin/orientation', ['as'=>'admin_orientation', 'uses'=>'AdminController@orientation']);

	Route::get('/admin/orientation/exporter', ['as'=>'exporter_orientation', 'uses'=>'AdminController@exporter_orientation']);

	Route::get('/admin/orientation/{id}/delete', ['as'=>'delete_orientation', 'uses'=>'AdminController@delete_orientation']);

	Route::post('/admin/orientation/{id}/update', ['as'=>'update_orientation', 'uses'=>'AdminController@update_orientation']);


	Route::get('/admin/orientation/classes', ['as'=>'orientation_classes', 'uses'=>'AdminController@orientation_classes']);

	Route::post('/admin/orientation/classes/store', ['as'=>'store_orientation_classes', 'uses'=>'AdminController@store_orientation_classes']);

	Route::get('/admin/orientation/classes/{id}/delete', ['as'=>'delete_orientation_classes', 'uses'=>'AdminController@delete_orientation_classes']);



	// Grille d'évaluation de l'enseignant
	Route::get('/admin/grille_evaluation', ['as'=>'admin_grille_evaluation', 'uses'=>'EnseignantsController@grille_evaluation']);

	Route::get('/admin/grille_evaluation/new', ['as'=>'new_grille_evaluation', 'uses'=>'EnseignantsController@new_grille_evaluation']);

	Route::post('/admin/grille_evaluation/store', ['as'=>'store_grille_evaluation', 'uses'=>'EnseignantsController@store_grille_evaluation']);

	Route::get('/admin/grille_evaluation/{id}/details', ['as'=>'admin_grille_evaluation_details', 'uses'=>'EnseignantsController@grille_evaluation_details']);

	Route::get('/admin/grille_evaluation/{id}/edit', ['as'=>'admin_grille_evaluation_edit', 'uses'=>'EnseignantsController@grille_evaluation_edit']);

	Route::post('/admin/grille_evaluation/{id}/update', ['as'=>'admin_grille_evaluation_update', 'uses'=>'EnseignantsController@grille_evaluation_update']);

	Route::get('/admin/grille_evaluation/{id}/delete', ['as'=>'admin_grille_evaluation_delete', 'uses'=>'EnseignantsController@grille_evaluation_delete']);


	// demandes de rencontre avec les parents
	Route::get('/admin/demandes_rencontre', ['as'=>'admin_demandes_rencontre', 'uses'=>'EnseignantsController@admin_demandes_rencontre']);

	Route::post('/admin/demandes_rencontre/{id}/update', ['as'=>'demandes_rencontre_update', 'uses'=>'EnseignantsController@demandes_rencontre_update']);

	Route::post('/admin/demandes_rencontre/{id}/rapport', ['as'=>'demandes_rencontre_rapport', 'uses'=>'EnseignantsController@demandes_rencontre_rapport']);

	//Route::get('/admin/fix_devoirs', ['as'=>'fix_devoirs', 'uses'=>'StudentsController@fix_devoirs']);



	// Fournitures de l'année  
	Route::get('/admin/fournitures_annee', ['as'=>'admin_fournitures_annee', 'uses'=>'EnseignantsController@admin_fournitures_annee']);

	Route::post('/admin/fournitures_annee/store', ['as'=>'admin_store_fournitures', 'uses'=>'EnseignantsController@admin_store_fournitures']);

	Route::post('/admin/fournitures_annee/{id}/update', ['as'=>'admin_fournitures_annee_update', 'uses'=>'EnseignantsController@admin_fournitures_annee_update']);

	Route::get('/admin/fournitures_annee/print', ['as'=>'print_fournitures_annee', 'uses'=>'EnseignantsController@print_fournitures_annee']);

	Route::get('/admin/fournitures_annee/{id}/destroy', ['as'=>'admin_fournitures_annee_destroy', 'uses'=>'EnseignantsController@fournitures_annee_destroy']);




});






Route::group(['middleware' => 'is_teacher'], function () {

	Route::get('/enseignant', ['as'=>'enseignant_index', 'uses'=>'EnseignantsController@enseignant_index']);

	Route::get('/enseignant/documents', ['as'=>'enseignant_documents', 'uses'=>'EnseignantsController@enseignant_documents']);

	Route::get('/enseignant/old_dossiers/{id}', ['as'=>'old_dossiers', 'uses'=>'EnseignantsController@old_dossiers']);

	Route::post('/enseignant/documents/folders/store', ['as'=>'folders_store', 'uses'=>'EnseignantsController@folders_store']);

	Route::post('/enseignant/documents/folders/{id}/update', ['as'=>'folder_update', 'uses'=>'EnseignantsController@folder_update']);


	Route::get('/enseignant/documents/folders/{id}/files', ['as'=>'folder_files', 'uses'=>'EnseignantsController@folder_files']);


	Route::post('/enseignant/documents/folders/{id}/files/store', ['as'=>'files_store', 'uses'=>'EnseignantsController@files_store']);

	Route::post('/enseignant/documents/folders/{id}/files/{file}/update', ['as'=>'files_update', 'uses'=>'EnseignantsController@files_update']);


	// profile
	Route::get('/enseignant/profile', ['as'=>'enseignant_profile', 'uses'=>'EnseignantsController@enseignant_profile']);

	Route::post('/enseignant/profile/update', ['as'=>'enseignant_profile_update', 'uses'=>'EnseignantsController@enseignant_profile_update']);

	Route::post('/enseignant/profile/update/password', ['as'=>'enseignant_profile_password_update', 'uses'=>'EnseignantsController@enseignant_profile_password_update']);


	// Répartition 
	Route::get('/enseignant/repartition', ['as'=>'enseignant_repartition', 'uses'=>'EnseignantsController@enseignant_repartition']);

	Route::post('/enseignant/repartition/store', ['as'=>'enseignant_store_repartition', 'uses'=>'EnseignantsController@enseignant_store_repartition']);


	// cahier journal 
	Route::get('/enseignant/cahier_journal', ['as'=>'cahier_journal', 'uses'=>'EnseignantsController@cahier_journal']);

	Route::post('/enseignant/cahier_journal/store', ['as'=>'cahier_journal_store', 'uses'=>'EnseignantsController@cahier_journal_store']);

	Route::post('/enseignant/cahier_journal/{id}/update', ['as'=>'cahier_journal_update', 'uses'=>'EnseignantsController@cahier_journal_update']);

	Route::get('/enseignant/cahier_journal/{id}/delete', ['as'=>'cahier_journal_delete', 'uses'=>'EnseignantsController@cahier_journal_delete']);


	// Devoirs 
	Route::get('/enseignant/devoirs', ['as'=>'enseignant_devoirs', 'uses'=>'EnseignantsController@enseignant_devoirs']);

	Route::post('/enseignant/devoirs/store', ['as'=>'enseignant_store_devoirs', 'uses'=>'EnseignantsController@enseignant_store_devoirs']);

	Route::post('/enseignant/devoirs/{id}/update', ['as'=>'devoirs_update', 'uses'=>'EnseignantsController@devoirs_update']);

	Route::get('/enseignant/devoirs/{id}/delete', ['as'=>'devoirs_delete', 'uses'=>'EnseignantsController@devoirs_delete']);


	// Préparation à l'exam 
	Route::get('/enseignant/preparation', ['as'=>'enseignant_preparation', 'uses'=>'EnseignantsController@enseignant_preparation']);

	Route::post('/enseignant/preparation/store', ['as'=>'preparation_store', 'uses'=>'EnseignantsController@preparation_store']);

	Route::post('/enseignant/preparation/{id}/update', ['as'=>'preparation_update', 'uses'=>'EnseignantsController@preparation_update']);




	// évaluations  
	Route::get('/enseignant/evaluations', ['as'=>'enseignant_evaluations', 'uses'=>'EnseignantsController@enseignant_evaluations']);

	Route::post('/enseignant/evaluations/store', ['as'=>'enseignant_evaluations_store', 'uses'=>'EnseignantsController@evaluations_store']);

	Route::get('/enseignant/ajax_class_devoirs', ['as'=>'ajax_class_devoirs', 'uses'=>'EnseignantsController@ajax_class_devoirs']);


	// Assiduité  
	Route::get('/enseignant/assiduite', ['as'=>'enseignant_assiduite', 'uses'=>'EnseignantsController@enseignant_assiduite']);

	Route::post('/enseignant/assiduite/store', ['as'=>'enseignant_assiduite_store', 'uses'=>'EnseignantsController@enseignant_assiduite_store']);

	Route::get('/enseignant/ajax_students_class', ['as'=>'ajax_students_class', 'uses'=>'EnseignantsController@ajax_students_class']);

	Route::get('/enseignant/ajax_subject_class', ['as'=>'ajax_subject_class', 'uses'=>'EnseignantsController@ajax_subject_class']);

	Route::get('/enseignant/assiduite/{id}/delete', ['as'=>'assiduite_delete', 'uses'=>'EnseignantsController@assiduite_delete']);


	// Contrôle continu  
	Route::get('/enseignant/evaluations/controle-continu', ['as'=>'enseignant_evaluations_controle', 'uses'=>'EnseignantsController@enseignant_evaluations_controle']);

	Route::post('/enseignant/evaluations/controle-continu/store', ['as'=>'controle_evaluations_store', 'uses'=>'EnseignantsController@controle_evaluations_store']);

	Route::post('/enseignant/evaluations/controle-continu/{id}/update', ['as'=>'controle_evaluations_update', 'uses'=>'EnseignantsController@controle_evaluations_update']);

	Route::get('/enseignant/evaluations/controle-continu/{id}/destroy', ['as'=>'enseignant_destroy_controle', 'uses'=>'EnseignantsController@enseignant_destroy_controle']);


	// compte rendu  
	Route::get('/enseignant/compte_rendu', ['as'=>'enseignant_compte_rendu', 'uses'=>'EnseignantsController@enseignant_compte_rendu']);

	Route::post('/enseignant/compte_rendu/store', ['as'=>'enseignant_compte_rendu_store', 'uses'=>'EnseignantsController@enseignant_compte_rendu_store']);

	Route::post('/enseignant/compte_rendu/{id}/update', ['as'=>'compte_rendu_update', 'uses'=>'EnseignantsController@compte_rendu_update']);

	Route::get('/enseignant/compte_rendu/{id}/delete', ['as'=>'compte_rendu_delete', 'uses'=>'EnseignantsController@compte_rendu_delete']);


	// absence request
	Route::get('/enseignant/absence_request', ['as'=>'enseignant_absence_request', 'uses'=>'EnseignantsController@enseignant_absence_request']);

	Route::post('/enseignant/absence_request/store', ['as'=>'absence_request_store', 'uses'=>'EnseignantsController@absence_request_store']);

	Route::get('/enseignant/absence_request/{id}/delete', ['as'=>'absence_request_delete', 'uses'=>'EnseignantsController@absence_request_delete']);


	Route::get('/enseignant/enseignants_heures_notif/{id}/readed', ['as'=>'enseignants_heures_notif', 'uses'=>'EnseignantsController@enseignants_heures_notif']);


	// Emploi du temps
	Route::get('/enseignant/emploi', ['as'=>'enseignant_emploi', 'uses'=>'AdminController@enseignant_emploi']);


	// docs request
	Route::get('/enseignant/demandes_documents', ['as'=>'enseignant_demandes_documents', 'uses'=>'EnseignantsController@demandes_documents']);

	Route::post('/enseignant/demandes_documents/store', ['as'=>'demandes_documents_store', 'uses'=>'EnseignantsController@demandes_documents_store']);

	Route::get('/enseignant/demandes_documents/{id}/delete', ['as'=>'demandes_documents_delete', 'uses'=>'EnseignantsController@demandes_documents_delete']);


	// documents
	Route::get('/enseignant/depot_documents', ['as'=>'enseignant_depot_document', 'uses'=>'AdminController@enseignant_depot_document']);



	// Grille d'évaluation de l'enseignant
	Route::get('/enseignant/grille_evaluation', ['as'=>'enseignant_grille_evaluation', 'uses'=>'EnseignantsController@grille_evaluation']);

	Route::get('/enseignant/grille_evaluation/{id}/details', ['as'=>'enseignant_grille_evaluation_details', 'uses'=>'EnseignantsController@grille_evaluation_details']);


	// cahier journal
	Route::get('/enseignant/cahier_journal/historique', ['as'=>'teacher_cahierjournal_historique', 'uses'=>'EnseignantsController@teacher_cahierjournal_historique']);


	// demandes de rencontre avec les parents
	Route::get('/enseignant/demandes_rencontre', ['as'=>'enseignant_demandes_rencontre', 'uses'=>'EnseignantsController@enseignant_demandes_rencontre']);

	Route::post('/enseignant/demandes_rencontre/store', ['as'=>'demandes_rencontre_store', 'uses'=>'EnseignantsController@demandes_rencontre_store']);

	Route::get('/enseignant/demandes_rencontre/{id}/delete', ['as'=>'demandes_rencontre_delete', 'uses'=>'EnseignantsController@demandes_rencontre_delete']);


	// Simili  
	Route::get('/enseignant/evaluations/simili', ['as'=>'enseignant_evaluations_simili', 'uses'=>'EnseignantsController@enseignant_evaluations_simili']);

	Route::post('/enseignant/evaluations/simili/store', ['as'=>'simili_evaluations_store', 'uses'=>'EnseignantsController@simili_evaluations_store']);

	Route::post('/enseignant/evaluations/simili/{id}/update', ['as'=>'simili_evaluations_update', 'uses'=>'EnseignantsController@simili_evaluations_update']);

	Route::get('/enseignant/evaluations/simili/{id}/destroy', ['as'=>'enseignant_destroy_simili', 'uses'=>'EnseignantsController@enseignant_destroy_simili']);


	// Avis et Notes
	Route::get('/enseignant/avis_notes', ['as'=>'enseignant_avis_notes', 'uses'=>'EnseignantsController@enseignant_avis_notes']);



	// Fournitures de l'année  
	Route::get('/enseignant/fournitures_annee', ['as'=>'enseignant_fournitures_annee', 'uses'=>'EnseignantsController@enseignant_fournitures_annee']);

	Route::post('/enseignant/fournitures_annee/store', ['as'=>'fournitures_annee_store', 'uses'=>'EnseignantsController@fournitures_annee_store']);

	//Route::post('/enseignant/fournitures_annee/{id}/update', ['as'=>'fournitures_annee_update', 'uses'=>'EnseignantsController@fournitures_annee_update']);

	Route::get('/enseignant/fournitures_annee/{id}/destroy', ['as'=>'fournitures_annee_destroy', 'uses'=>'EnseignantsController@fournitures_annee_destroy']);




});


Route::group(['middleware' => 'is_student'], function () {

	Route::get('/eleve', ['as'=>'students_index', 'uses'=>'StudentsController@students_index']);

	// evaluations 
	Route::get('/eleve/evaluations', ['as'=>'students_evaluations', 'uses'=>'StudentsController@students_evaluations']);


	// profile
	Route::get('/eleve/profile', ['as'=>'student_profile', 'uses'=>'StudentsController@student_profile']);

	Route::post('/eleve/profile/update/password', ['as'=>'student_profile_password_update', 'uses'=>'StudentsController@student_profile_password_update']);


	// Assiduité  
	Route::get('/eleve/assiduite', ['as'=>'student_assiduite', 'uses'=>'StudentsController@student_assiduite']);


	// devoirs 
	Route::get('/eleve/devoirs', ['as'=>'students_devoirs', 'uses'=>'StudentsController@students_devoirs']);

	Route::get('/eleve/travaux_afaire', ['as'=>'travaux_afaire', 'uses'=>'StudentsController@travaux_afaire']);

	Route::get('/eleve/devoirs/{id}/details', ['as'=>'devoir_details', 'uses'=>'StudentsController@devoir_details']);


	// Contrôle continu  
	Route::get('/eleve/evaluations/controle-continu', ['as'=>'student_evaluations_controle', 'uses'=>'StudentsController@student_evaluations_controle']);


	// Simili  
	Route::get('/eleve/evaluations/simili', ['as'=>'student_evaluations_simili', 'uses'=>'StudentsController@student_evaluations_simili']);


	// compte rendu  
	Route::get('/eleve/compte_rendu', ['as'=>'student_compte_rendu', 'uses'=>'StudentsController@student_compte_rendu']);

	// Préparation à l'exam 
	Route::get('/eleve/preparation', ['as'=>'students_preparation_exam', 'uses'=>'StudentsController@preparation_exam']);


	// dossiers / ressources 
	Route::get('/eleve/dossiers', ['as'=>'students_dossiers', 'uses'=>'StudentsController@students_dossiers']);

	Route::get('/eleve/dossiers/{id}/ressources', ['as'=>'students_ressources', 'uses'=>'StudentsController@students_ressources']);


	// Emploi du temps
	Route::get('/eleve/emploi', ['as'=>'students_emploi', 'uses'=>'AdminController@students_emploi']);

	// documents
	Route::get('/eleve/depot_documents', ['as'=>'students_depot_document', 'uses'=>'AdminController@students_depot_document']);

	// orientation
	Route::post('/eleve/orientation/store', ['as'=>'student_store_orientation', 'uses'=>'StudentsController@student_store_orientation']);


	// Avis et Notes
	Route::get('/eleve/avis_notes', ['as'=>'eleve_avis_notes', 'uses'=>'StudentsController@eleve_avis_notes']);


});	